/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/* 
 * interface to output XML files from dmachinemon
 * 2001 Jul 13
 * $Id: dmachinemon-xmloutput.c,v 1.5 2002/05/22 11:11:17 dancer Exp $
 */
/* 
 * GTK+ interface for load average monitor program.
 * 2001 Jun 9 Junichi Uekawa
 */


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <pthread.h>

#include "dmachinemon/dmachinemon.h"
#include "config.h"


char * hostname ;
char * portnumber;

void printspace(int c)
{
  while ( c-- )
    printf(" ");
}

void processing_command ()
{
  int fd = dm_connect_to_host(hostname, atoi(portnumber));
  FILE* f=(fd!=-1)?fdopen (fd, "r"):NULL;
  dm_machinelist * new = NULL;

  if (!f)
    {
      fprintf (stderr, "dmachinemon-xmloutput: cannot open server socket\n");
      exit(1);
    }

  if (dm_process_nodes_input (f, &maininfo, NULL, NULL))
    {
      fprintf (stderr, "Could not handle input...\n");
      exit (1);
    }  
  fclose(f);

				/* displaying process */
  new = maininfo.machinedb;

  while(new)
    {
      dm_pairstring * p = new->data;
      printf ("  <machine machinename=\"%s\">\n",
	      new->machinename);
      while(p)
	{
	  printf ("    <%s>%s</%s>\n", 
		  p->stringtitle,
		  p->stringdata,
		  p->stringtitle);
	  p=p->next;
	}
      printf ("  </machine>\n");
      new = new -> next;
    }

  return ;  
}

int main(int ac, char ** av)
{ 
  dm_commandoption cdat;
  setlocale(LC_TIME, "");

  dmachinemon_parse_options(ac, av, &cdat);
  if (!cdat.parenthostname)
    {
      fprintf (stderr, 
	       "dmachinemon-xmloutput v. %s \n\n"
	       "Not enough command-line information specified\n\n"
	       ,VERSION
	       );
      dmachinemon_print_commandline_help();
      return 1;
    }

  hostname=cdat.parenthostname;
  portnumber=cdat.port_client;

  printf("<?xml version=\"1.0\"?>\n"
	 "<machinelist>\n");
  processing_command();  
  printf("</machinelist>\n");
  
  return 0;
}
