/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * super proxy program, receives the port number to listen on, and the command line parameter.
 */
/* 
 * 2001 Oct 2 
 * $Id: superproxy.c,v 1.5 2002/05/22 03:21:35 dancer Exp $
 * $Log: superproxy.c,v $
 * Revision 1.5  2002/05/22 03:21:35  dancer
 * fix typo
 *
 * Revision 1.4  2002/05/22 03:20:42  dancer
 * 2002-05-22  Junichi Uekawa  <dancer@debian.org>
 *
 * 	* tools/dmscripts/dmboot.1: document the change.
 *
 * 	* tools/dmscripts/dmboot: allow arbitrary options to be passed to dmachinemon,
 * 	if it is passed to dmboot.
 *
 * 2002-05-21  Junichi Uekawa  <dancer@debian.org>
 *
 * 	* tools/treeview/superproxy.c (handle_clients): add memfree routine.
 *
 * Revision 1.3  2001/11/07 07:35:06  dancer
 * changed structure name to use dm_
 *
 * Revision 1.2  2001/11/07 06:32:42  dancer
 * library interface has been cleaned up, to prepend all functions with
 * "dm_" prefix.
 *
 * Revision 1.1  2001/10/02 12:14:56  dancer
 * super proxy program, for use with many apps, I suppose.
 *
 *
 */

#include <stdio.h>
#include <dmachinemon/dmachinemon.h>

static char * commandline = NULL ;

static int 
handle_clients(void * data)
{				/* access from clients. */
  int t = ((struct dm_handle_incoming_params*)data)->t;
  FILE* fout = (t!=-1)?fdopen(t, "w"):NULL;
  FILE* fin = popen (commandline, "r");
  int i;
  
  
  if (fin == NULL || fout == NULL)
    {
      fprintf(stderr, "wow\n");
      exit (1);
    }
  
  while ((i = fgetc(fin))!=EOF)
    {
      fputc (i, fout);
    }
  
  fclose(fin);
  fclose(fout);
  dm_tcp_free_incoming_params(data);
  return 0;  
}

int main (int ac, char ** av)
{
  commandline = av[2];
  
  if (av[2])
    dm_tcp_host_setup("superproxy", av[1],
		      (void * )handle_clients);
  else
    {
      fprintf(stderr, "superproxy: \n"
	      "\t superproxy port [command-line]\n\n"
	      "Runs program and proxizes to port\n"
	      );
    }
  
  return 0;
   
}
