/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Network load viewer. Views network load, and sends it through dmachinemon network.
 * per-minute load.
 */
/* 
 * 2001 Nov 23
 * $Id: dmachinemon-netload.c,v 1.6 2002/05/25 08:33:29 dancer Exp $
 */


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <unistd.h>
#include <dmachinemon/dmachinemon.h>


#define PROGRAMNAME "dmachinemon-netload"
#define SLEEPTIME 1000000 * 60

typedef struct datapair
{
  char * name;
  long prev_receive;
  long prev_send;
  long receive;
  long send;
  struct datapair * next;
} datapair;

/* returns the datapair (base)
 It will add. 

keeps the network load information.
*/
static datapair * 
update_datapair ( datapair* mydata, char* myname, long receive, long  send)
{
  if (mydata && (!strcmp(myname, mydata->name)))
    {
      mydata->prev_receive=mydata->receive;
      mydata->prev_send=mydata->send;
      mydata->receive=receive;
      mydata->send=send;

      return mydata;
    }
  else
    {
      if (mydata && mydata->next)
	{
	  update_datapair(mydata->next, myname, receive, send);
	  return mydata;
	}
      else
	{
	  datapair * new = malloc (sizeof(datapair));
	  new->name = strdup(myname);
	  new->prev_send=new->send=send;
	  new->prev_receive=new->receive=receive;
	  new->next = NULL;
	  
	  if (mydata)
	    {
	      mydata->next = new;
	      return mydata;
	    }
	  else
	    {
	      return new;
	    }
	  
	}
    }
  
}



static void
processing_command()
{
  char * interface=NULL;
  long receivebytes;
  long sendbytes;
  datapair * data = NULL;
  datapair * tmpdata ;
  
  while (1)
    { 
      /* FIXME Linux specific */
      FILE * filebuf;
      filebuf = popen ("cat /proc/net/dev | awk 'BEGIN{i=0} {A=$0; B=$1; sub (\":[^:]*$\",\"\",B); sub(\"^[^:]*:\",\"\",A); split(A,C,\" \"); if ( i++ > 2) {print B \" \" C[1] \" \" C[9] }}'", "r");
      
      while (3==fscanf(filebuf, "%as%li%li", &interface, &receivebytes, &sendbytes))
	{
	  data = update_datapair (data, interface, receivebytes, sendbytes);
	  free (interface);
	}
      pclose (filebuf);
      tmpdata = data;

      while (tmpdata)
	{
	  char * tag, * content;
	  int ret = 0;
	  
	  
	  asprintf (&tag, "network-%s-send", tmpdata->name);
	  asprintf (&content, "%li", tmpdata->send - tmpdata->prev_send );
	  ret += dm_sendinfo (tag, content);
	  free (tag); free(content);

	  asprintf (&tag, "network-%s-recv", tmpdata->name);
	  asprintf (&content, "%li", tmpdata->receive - tmpdata->prev_receive );
	  ret += dm_sendinfo (tag, content);
	  
	  free (tag); free(content);

	  tmpdata=tmpdata->next;
	  if (ret)
	    {
	      /* FIXME: I should probably resume. */
	      fprintf(stderr, "cannot link to parent node. Dying\n");
	      exit (1);
	    }
	}
      
      usleep ( SLEEPTIME );
    }  
}

int
main(int ac, char ** av)
{ 
  int t = time(NULL);
  srand(t);
  
  dm_Init(&ac, &av);
  processing_command();
  dm_Finalize();
  
  return 0;
}
