/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Master node
 */
/* 
 * Master node for access. : port for nodes,  port for accessors.
 * 2001 June 9
 *  Junichi Uekawa
 * $Id: dmachinemon-master.c,v 1.21 2002/05/22 11:11:17 dancer Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "dmachinemon/dmachinemon-servent-libroute.h"
#include "dmachinemon/dmachinemon-master.h"
#include "config.h"


static int max_seen_by_depth = 0;
static dm_commandoption cdat;	/* the command data. */

static int 
handle_clients(void * data)
{				/* access from clients. */
  int t = ((struct dm_handle_incoming_params*)data)->t;
  FILE* f = (t!=-1)?fdopen(t, "w"):NULL;

  /* although this is suboptimal (depends on number of clients connecting) the 
   master node does not have a reliable clock (yeah, right). It should work fine ... 
   FIXME: dm_randomly_change_route_to should be called periodically in regular intervals
  */
  if (cdat.debuglevel > 3) fprintf (stderr, "DEBUG: master node is running Randomly-change-route-to.\n");

  if (!cdat.downlink_static)
    dm_randomly_change_route_to (&maininfo, &cdat);
  master_send_info_to_client (f, &maininfo, 0, max_seen_by_depth, &cdat); /* clear the info./ no. it will remove a lot of info. */
  fclose(f);
  dm_tcp_free_incoming_params(data);
  return 0;  
}

static int
handle_nodes(void * data)
{				/* access from nodes. */
  int t = ( (struct dm_handle_incoming_params*) data )->t;
  FILE*f;
  int return_code;

  dm_send_route(t, &cdat);

  f = (t!=-1)?fdopen(t, "w+"):NULL;
  
  return_code = dm_process_nodes_input (f, &maininfo, NULL, NULL);
  if (f) fclose(f);
  dm_tcp_free_incoming_params(data);
  return return_code;
}

static void 
tcphosts(void * parameter)
{
  dm_tcp_host_setup("dmachinemon-master", (char*)parameter,
		 (void * )handle_nodes);
}

int main(int ac, char ** av)
{
  pthread_t thread;

  dmachinemon_parse_options(ac, av, &cdat);
  max_seen_by_depth = cdat.number_of_hosts_of_seenby;
  
  fprintf (stderr, "dmachinemon-master v. %s starting\n", VERSION);
  
  pthread_create(&thread, NULL, (void*)tcphosts, cdat.port_nodes);
  dm_tcp_host_setup("dmachinemon-master", cdat.port_client,
		 (void * )handle_clients);
  return 0;  
}

