/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/* 
 * header file for updating the database for node data
 * $Id: dmachinemon-libdatabase.h,v 1.10 2002/05/20 07:31:01 dancer Exp $
 * 
 */

#ifndef __DMACHINEMON_LIBDATABASE_H
#define __DMACHINEMON_LIBDATABASE_H

#define CLIENTSEENCOUNT_THRESHOLD 50 /* this needs to be larger, like 1000,
				     but it won't detect dead links... */

#include <pthread.h>
#include <stdio.h>


/**
   Pairstring for data-string pair.
   Database is stored in this format.
 */
typedef struct dm_pairstring
{
  /// the key
  char * stringtitle;
  /// the data
  char * stringdata;
  struct dm_pairstring * next;
  /// lock
  pthread_mutex_t lock;
} dm_pairstring;


/**
   Machinelist structure.
   Holds information for each machine.
 */
typedef struct dm_machinelist
{
  /// data in pairstring format.
  dm_pairstring* data;
  /// name of machine
  char * machinename;
  struct dm_machinelist* next;
  /** some kind of original data */
  void * applicationdata ;	
  pthread_mutex_t lock;
  /** some kind of SEEN-Flag. -- will be 1 if seen,
      0 if not seen by the uplink */
  int dataseenflag;		
  /** number of times the data is viewed by the client. (old data will have high number of things here... For debugging purposes, to note dead machines) */
  int clientseencount;		
} dm_machinelist;

/**
   the structure to be passed around.
*/
typedef struct dm_machinelist_information 
{
  /** machine database  */
  dm_machinelist * machinedb;
  /** please lock when accessing the 
      machindb variable. Not anytime else.*/
  pthread_mutex_t machinedb_lock;
} dm_machinelist_information;

void dm_update_db (dm_machinelist * mine, dm_pairstring * ps,
		const char * category, const char * string);
const char * dm_get_value_text(dm_machinelist * now, const char * title); /* does not malloc. -- read only data*/
float dm_get_value_float(dm_machinelist*now, const char*title); 


/*
 * Processes node input... :
 *   FILE*f : file input.
 *   dm_machinelist: the database
 *   function : callback function to implement data, with char* (if applicable. NULL is accepted)
 *   void*data: the data to be sent to function.
 */
int dm_process_nodes_input (FILE*f, dm_machinelist_information * machinedbinfo, void* (*createapplicationdatacallback)(void*, const char* ), void * data); 
dm_machinelist * dm_search_machine (dm_machinelist_information * machinedbinfo, 
			      const char * name ); /* search for a machine in list and return the address, or NULL if not found. */

				/* count the number of nodes in the database. */
int dm_count_nodes_number (dm_machinelist_information * machinedbinfo);


extern dm_machinelist_information maininfo;


#define SEEN_BY "Seen-By"

#endif
